/**
 * Base class of Drag
 * @example:
 * Drag.init( header_element, element );
 */
var Drag = {
	// elementãһֻקһElement
	obj: null , 
	/**
	 * @param: elementHeader	used to drag..
	 * @param: element			used to follow..
	 */
	init: function(elementHeader, element) {
		//  start 󶨵 onmousedown ¼괥 start
		elementHeader.onmousedown = Drag.start;
		//  element 浽 header  obj 棬 header קʱ
		elementHeader.obj = element;
		// ʼԵ꣬Ϊ position = absolute ԲʲôãǷֹ onDrag ʱ parse 
		if(isNaN(parseInt(element.style.left))) {
			element.style.left = "0px";
		}
		if(isNaN(parseInt(element.style.top))) {
			element.style.top = "0px";
		}
		// Ͽ Functionʼ⼸Ա Drag.init úŰﶨʵʵĺ
		element.onDragStart = new Function();
		element.onDragEnd = new Function();
		element.onDrag = new Function();
	},
	// ʼקİ󶨣󶨵ƶ event 
	start: function(event) {
		var element = Drag.obj = this.obj;
		// ͬ event ģͲͬ
		event = Drag.fixE(event);
		// ǲ
		if(event.which != 1){
			// 
			return true ;
		}
		// ĽͣϿʼקĹ
		element.onDragStart();
		// ¼
		element.lastMouseX = event.clientX;
		element.lastMouseY = event.clientY;
		// ¼
		document.onmouseup = Drag.end;
		document.onmousemove = Drag.drag;
		return false ;
	}, 
	// Elementڱ϶ĺ
	drag: function(event) {
		event = Drag.fixE(event);
		if(event.which == 0 ) {
		 	return Drag.end();
		}
		// ڱ϶Element
		var element = Drag.obj;
		// 
		var _clientX = event.clientY;
		var _clientY = event.clientX;
		// ûʲô
		if(element.lastMouseX == _clientY && element.lastMouseY == _clientX) {
			return	false ;
		}
		// ղ Element 
		var _lastX = parseInt(element.style.top);
		var _lastY = parseInt(element.style.left);
		// µ
		var newX, newY;
		// µ꣺ԭȵ+ƶֵ
		newX = _lastY + _clientY - element.lastMouseX;
		newY = _lastX + _clientX - element.lastMouseY;
		// ޸ element ʾ
		element.style.left = newX + "px";
		element.style.top = newY + "px";
		// ¼ element ڵ깩һƶʹ
		element.lastMouseX = _clientY;
		element.lastMouseY = _clientX;
		// Ľͣҽ Drag ʱĹ
		element.onDrag(newX, newY);
		return false;
	},
	// Element ڱͷŵĺֹͣק
	end: function(event) {
		event = Drag.fixE(event);
		// ¼
		document.onmousemove = null;
		document.onmouseup = null;
		// ȼ¼ onDragEnd ĹӣƳ obj
		var _onDragEndFuc = Drag.obj.onDragEnd();
		// קϣobj 
		Drag.obj = null ;
		return _onDragEndFuc;
	},
	// ͬ event ģͲͬ
	fixE: function(ig_) {
		if( typeof ig_ == "undefined" ) {
			ig_ = window.event;
		}
		if( typeof ig_.layerX == "undefined" ) {
			ig_.layerX = ig_.offsetX;
		}
		if( typeof ig_.layerY == "undefined" ) {
			ig_.layerY = ig_.offsetY;
		}
		if( typeof ig_.which == "undefined" ) {
			ig_.which = ig_.button;
		}
		return ig_;
	}
};